﻿<?php
session_start();
include 'conexao.php';

// ✅ Verifica se está logado
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$professor_id = $_SESSION['usuario']['id'];
$professor_nome = $_SESSION['usuario']['nome'];

$msg = "";
// ✅ Upload do material
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['material'])) {
    $titulo = $conn->real_escape_string($_POST['titulo']);
    $descricao = $conn->real_escape_string($_POST['descricao']);
    $arquivo = $_FILES['material']['name'];
    $tipo_arquivo = $_FILES['material']['type'];
    $tamanho_arquivo = $_FILES['material']['size'];

    // Supondo que você tenha campos de formulário para disciplina e turma
    $disciplina = $conn->real_escape_string($_POST['disciplina'] ?? 'Não informada');
    $turma = $conn->real_escape_string($_POST['turma'] ?? 'Não informada');

    $pasta = "uploads/";

    if (!is_dir($pasta)) {
        mkdir($pasta, 0777, true);
    }

    // Caminho completo
    $caminho_completo = $pasta . basename($arquivo);

    if (move_uploaded_file($_FILES['material']['tmp_name'], $caminho_completo)) {
        // ✅ A consulta foi ajustada para combinar com a sua tabela
        $stmt = $conn->prepare("INSERT INTO upload (professor_id, nome_professor, nome_arquivo, descricao, tipo_arquivo, tamanho_arquivo, disciplina, turma, caminho, data_upload) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
        
        // A string de tipo 'issssssss' tem que ter 9 's' para as 9 variáveis que vai ter
        $stmt->bind_param("issssssss", $professor_id, $professor_nome, $arquivo, $descricao, $tipo_arquivo, $tamanho_arquivo, $disciplina, $turma, $caminho_completo);

        if ($stmt->execute()) {
            $msg = "✅ Plano de aula enviado com sucesso!";
        } else {
            $msg = "❌ Erro ao salvar no banco: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $msg = "❌ Erro ao enviar o arquivo.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload do Plano de Aula</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f6f9; margin: 0; padding: 0; }
        header { background: #004085; color: #fff; padding: 15px; text-align: center; }
        .container { max-width: 600px; background: #fff; margin: 20px auto; padding: 20px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h2 { color: #004085; text-align: center; }
        label { display: block; margin-top: 12px; font-weight: bold; }
        input, textarea { width: 100%; padding: 10px; margin-top: 6px; border: 1px solid #ccc; border-radius: 6px; }
        button { margin-top: 15px; width: 100%; background: #004085; color: #fff; padding: 12px; border: none; border-radius: 6px; cursor: pointer; font-size: 16px; }
        button:hover { background: #0069d9; }
        .msg { margin-top: 10px; text-align: center; font-weight: bold; color: green; }
        .professor { background: #e9ecef; padding: 10px; border-radius: 6px; margin-bottom: 15px; }
        .lista { margin-top: 30px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 8px; border-bottom: 1px solid #ddd; text-align: left; }
        th { background: #004085; color: white; }
        @media (max-width: 600px) {
            .container { margin: 10px; padding: 15px; }
            button { font-size: 14px; }
        }
    </style>
</head>
<body>

<header>
    <h1>📂 Upload do Plano de Aula</h1>
</header>

<div class="container">
    <div class="professor">
        👨‍🏫 Professor Logado: <b><?php echo htmlspecialchars($professor_nome); ?></b>
    </div>

    <h2>Enviar Novo Plano de Aula</h2>
    <form method="POST" enctype="multipart/form-data">
        <label for="titulo">Título:</label>
        <input type="text" name="titulo" required>

        <label for="descricao">Descrição:</label>
        <textarea name="descricao" rows="4"></textarea>

        <label for="material">Selecione o Arquivo:</label>
        <input type="file" name="material" required>
        
        <label for="disciplina">Disciplina:</label>
        <input type="text" name="disciplina">

        <label for="turma">Turma:</label>
        <input type="text" name="turma">

        <button type="submit">Enviar Plano</button>
    </form>

    <?php if ($msg) echo "<p class='msg'>$msg</p>"; ?>

    <div class="lista">
        <h2>📑 Arquivos Enviados</h2>
        <table>
            <tr>
                <th>Descrição</th>
                <th>Arquivo</th>
                <th>Disciplina</th>
                <th>Turma</th>
                <th>Data</th>
            </tr>
            <?php
            // A consulta é para mostrar apenas os arquivos do professor logado.
            // Para isso, usa-se a coluna 'professor_id' da tabela 'upload'.
            $result = $conn->query("SELECT * FROM upload WHERE professor_id = $professor_id ORDER BY data_upload DESC");
            while ($row = $result->fetch_assoc()) {
                echo "<tr>
                        <td>".htmlspecialchars($row['descricao'])."</td>
                        <td><a href='uploads/".htmlspecialchars($row['nome_arquivo'])."' target='_blank'>📥 Baixar</a></td>
                        <td>".htmlspecialchars($row['disciplina'])."</td>
                        <td>".htmlspecialchars($row['turma'])."</td>
                        <td>{$row['data_upload']}</td>
                    </tr>";
            }
            ?>
        </table>
    </div>
</div>

</body>
</html>